PAGE	66,132
;
; SCP's OEM disk initialization module to link with
; Microsoft's FORMAT.OBJ disk formatting program.
; Revised 6-21-82.
;
BIOSSEG	EQU	40H	; Where boot sector loads IO.SYS.
BOOTER	EQU	200H	; "B" command puts boot sector here.

SEGBIOS	SEGMENT	AT BIOSSEG
BIOS	LABEL	FAR
SEGBIOS	ENDS

CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE
	PUBLIC	FATID,STARTSECTOR,SWITCHLIST,FREESPACE
	PUBLIC	INIT,DISKFORMAT,BADSECTOR,DONE
	EXTRN	SWITCHMAP:WORD,DRIVE:BYTE
;
; Select disk controller:
;
SCP		EQU	0	; Seattle Computer Products controller.
TARBELLSINGLE	EQU	0	; Tarbell single-density controller.
TARBELLDOUBLE	EQU	1	; Tarbell double-density controller.
CROMEMCO4FDC	EQU	0	; Cromemco 4FDC.
CROMEMCO16FDC	EQU	0	; Cromemco 16FDC.

LARGE		EQU	0	; All 8-inch disks.
COMBIN		EQU	0	; Some 8-inch and some 5.25-inch.
SMALL		EQU	0	; All 5.25-inch disks.
CUSTOM		EQU	0	; Custom drive configuration.

LARGEDS		EQU	0	; Turn this on if 8-inch disks are double-
				;  sided in double-density mode.
SMALLDS		EQU	0	; Turn this on if 5.25-inch disk are double-
				;  sided in double-density mode.
;
; Turn this on if 8-inch drives are PerSci.  This currently only works
; for the SCP controller.  The Cromemco controllers seek and restore
; using slow-speed steps (use STPSPD = 2 for 10mS steps).
;
FASTSEEK	EQU	0

STPSPD		EQU	2
;
; *******************************************************************
;
TARBELL		EQU	TARBELLSINGLE + TARBELLDOUBLE
CROMEMCO	EQU	CROMEMCO4FDC + CROMEMCO16FDC

	IF	SCP
DISK		EQU	0E0H
DONEBIT		EQU	01H
SMALLBIT	EQU	10H
BACKBIT		EQU	04H
DDENBIT		EQU	08H
	ENDIF

	IF	TARBELL
DISK		EQU	78H
DONEBIT		EQU	80H
BACKBIT		EQU	40H
DDENBIT		EQU	08H
	ENDIF

	IF	CROMEMCO
DISK		EQU	30H
DONEBIT		EQU	1
SMALLBIT	EQU	10H
BACKBIT		EQU	0FDH		; Send this to port 4 to select back.
DDENBIT		EQU	40H
	ENDIF

B_BIT		EQU	08H		; Mask bits for SWITCHMAP.
C_BIT		EQU	04H		; This must be up here instead of near
D_BIT		EQU	02H		;  SWITCHLIST because the assembler
S_BIT		EQU	01H		;  can't handle the forward references.

INIT:
	CLC			; No errors.
	RET

DISKFORMAT:

	IF	SCP+TARBELLDOUBLE+CROMEMCO16FDC
	TEST	BYTE PTR [SWITCHMAP],C_BIT
	JZ	KNOW_DENSITY
;
; If we are just clearing the disk, it is not necessary for the operator
; to specify the correct density.  Therefore, look at the disk to figure
; out what it really is.
;
	IF	CROMEMCO16FDC
	CALL	MOTORON		; If 16FDC, wait for motors up to speed.
	ENDIF

	MOV	CX,4		; Try each density twice
CHKDENS:
	CALL	DRIVESELECT	; Select drive.
	OUT	DISK+4,AL	; Select disk
	MOV	AL,0C4H		; READ ADDRESS command
	CALL	DCOM
	AND	AL,98H
	IN	AL,DISK+3	; Eat last byte to reset DRQ
	JZ	KNOW_DENSITY	; Jump if no error in reading address.
	XOR	BYTE PTR [SWITCHMAP],D_BIT	; Try other density
	LOOP	CHKDENS
	MOV	DX,OFFSET READ_ERROR	; Error message.
	JMP	ERROR
KNOW_DENSITY:
	ENDIF

	CALL	TABLE		; SI points to table of info for disk format.
	MOV	AL,[SI+10]	; Get FATID byte for this format.
	MOV	[FATID],AL
	MOV	AX,[SI+11]	; Get STARTSECTOR for this format.
	MOV	[STARTSECTOR],AX
	TEST	BYTE PTR [SWITCHMAP],C_BIT
	JZ	DOIT
	JMP	BOOT_SECTOR	; Skip disk initialization if /C bit is on.
DOIT:
	MOV	BX,OFFSET PATTERN
	MOV	DX,[SI+6]	; DX points to index pattern.
	CALL	MAKE		; Make pattern for index mark and one sector
	MOV	CL,[SI]		; Get sector count for this sector.
	DEC	CL		; Repeat sector pattern for remaining sectors.
MAKSEC:
	MOV	DX,[SI+8]	; DX points to sector pattern.
	CALL	MAKE
	DEC	CL
	JNZ	MAKSEC
	CALL	MAKE		; Fill out rest of track.
;
; Put in sequential sector numbers.
;
	MOV	AL,1		; Start with sector number 1
	MOV	CL,AL		; Add one to each succeeding sector number
	MOV	BX,[SI+2]	; Get offset from beginning of pattern to first
	INC	BX		;  track number.  Increment to side,
	INC	BX		;  then sector.
	ADD	BX,OFFSET PATTERN	; Compute actual memory address.
	CALL	PUTSEC

	IF	CROMEMCO16FDC-1
	CALL	DRIVESELECT	; Get drive-select byte.
	OUT	DISK+4,AL	; Send it out.
	ENDIF

	IF	CROMEMCO16FDC
	CALL	MOTORON		; Wait for spindle motor to come up to speed.
	ENDIF

	CALL	RESTORE		; Move the head to track 0.
	JZ	TRACK0		; Jump if no problem with restoring.
	MOV	DX,OFFSET SEEK_ERROR	; Error message.
	JMP	ERROR
TRACK0:
	XOR	DL,DL		; Start with track 0.
TRACKLOOP:
	MOV	AL,DL		; Get track number.
	MOV	BX,[SI+2]	; Address of first track number in pattern.
	ADD	BX,OFFSET PATTERN
	MOV	CL,0
	CALL	PUTSEC		; Put track number in each sector.

	IF	SCP+TARBELLDOUBLE
	CALL	DRIVESELECT	; Get drive-select byte.
	OUT	DISK+4,AL	; Select side.
	ENDIF

	IF	CROMEMCO16FDC
	MOV	AL,0FFH		; Select front side if 16FDC.
	OUT	04H,AL
	ENDIF

	SUB	DH,DH		; Start with side 0.
SIDELOOP:
	MOV	AL,DH		; Get side number.
	MOV	BX,[SI+2]	; Get offset from beginning of pattern to first
	INC	BX		;  track number.  Increment to side.
	ADD	BX,OFFSET PATTERN	; Compute actual memory address.
	MOV	CL,0
	CALL	PUTSEC		; Put side byte in each sector
;
; Write a track.
;
	CALL	TRACK
	JNC	CHECK_SIDE	; Jump if no error.
	MOV	DX,OFFSET WRITE_ERROR	; Error message.
	JMP	ERROR
CHECK_SIDE:

	IF	(SCP+CROMEMCO16FDC)*(LARGEDS+SMALLDS)+TARBELLDOUBLE*LARGEDS
	CALL	DRIVESELECT	; Get drive-select byte.
	TEST	AL,DDENBIT	; See if double-density.
	JZ	NEXTRACK	; Jump if not (single-density always SS).
	ENDIF

	IF	SCP*LARGEDS*(SMALLDS-1)+CROMEMCO16FDC*SMALLDS*(LARGEDS-1)
	TEST	AL,SMALLBIT	; Check for small disk.
	JNZ	NEXTRACK	; Jump if small because SMALLDS is off or,
	ENDIF			; jump if large because LARGEDS is off.

	IF	SCP*(LARGEDS-1)*SMALLDS+CROMEMCO16FDC*(SMALLDS-1)*LARGEDS
	TEST	AL,SMALLBIT	; Check for large disk.
	JZ	NEXTRACK	; Jump if large because LARGEDS is off or,
	ENDIF			; jump if small because SMALLDS if off.

	IF	(SCP+CROMEMCO16FDC)*(LARGEDS+SMALLDS)+TARBELLDOUBLE*LARGEDS
	INC	DH		; Next side.
	CMP	DH,2		; See if too big.
	JAE	NEXTRACK	; Finished this track, on to the next.

	IF	SCP+TARBELLDOUBLE
	OR	AL,BACKBIT	; Select back side.
	OUT	DISK+4,AL
	ENDIF

	IF	CROMEMCO
	MOV	AL,BACKBIT	; Select back side.
	OUT	04H,AL
	ENDIF

	JMP	SHORT SIDELOOP	; Do the back side.
NEXTRACK:
	ENDIF

	INC	DL		; Next track.
	CMP	DL,[SI+1]	; See if done.
	JAE	FINIS
	MOV	AL,58H+STPSPD	; Step in with update, no verify.
	CALL	DCOM
	TEST	AL,098H		; Check for errors, Not Ready,
	JZ	TRACKLOOP	;  Seek Error, CRC Error.
	MOV	DX,OFFSET SEEK_ERROR
	JMP	SHORT ERROR
FINIS:
	CALL	RESTORE		; Move the head back.
	MOV	DX,OFFSET SEEK_ERROR	; Error message in case of error.
	JNZ	ERROR
;
; Transfer the boot sector to the disk.
;
BOOT_SECTOR:
	IF	(SCP+CROMEMCO16FDC)*(LARGEDS+SMALLDS)+TARBELLDOUBLE*LARGEDS
	CALL	DRIVESELECT	; Get drive-select byte.
	TEST	AL,DDENBIT	; If single-density, transfer single-sided boot
	JZ	POKE_SINGLE
	ENDIF

	IF	SCP*LARGEDS*(SMALLDS-1)+CROMEMCO16FDC*SMALLDS*(LARGEDS-1)
	TEST	AL,SMALLBIT	; Check for small disk.
	JNZ	POKE_SINGLE	; Jump if small because SMALLDS is off or,
	ENDIF			; jump if large because LARGEDS is off.

	IF	SCP*(LARGEDS-1)*SMALLDS+CROMEMCO16FDC*(SMALLDS-1)*LARGEDS
	TEST	AL,SMALLBIT	; Check for large disk.
	JZ	POKE_SINGLE	; Jump if large because LARGEDS is off or,
	ENDIF			; jump if small because SMALLDS if off.

	IF	(SCP+CROMEMCO16FDC)*(LARGEDS+SMALLDS)+TARBELLDOUBLE*LARGEDS
POKE_DOUBLE:
	MOV	AX,[SI+13]	; Poke number of sectors to load into boot.
	MOV	WORD PTR [B2POKE_SECTOR+1],AX
	MOV	AL,[SI+11]	; Poke STARTSECTOR into boot sector.
	INC	AL		; First sector on a track is 1, not 0.
	MOV	BYTE PTR [B2POKE_FIRSECT+1],AL
	MOV	AL,[SI]		; Poke sectors/track two places into boot.
	MOV	BYTE PTR [B2POKE_HALFSECT_1+1],AL
	MOV	BYTE PTR [B2POKE_HALFSECT_2+1],AL
	SAL	AL,1		; Compute number of sectors/"cylinder".
	MOV	BYTE PTR [B2POKE_MAXSECT_1+2],AL
	MOV	BYTE PTR [B2POKE_MAXSECT_2+2],AL
	CALL	DRIVESELECT	; Get drive-select byte.

	IF	SCP
	AND	AL,0FCH		; Force drive 0.
	ENDIF

	IF	TARBELL
	AND	AL,0CFH		; Force drive 0.
	ENDIF

	IF	CROMEMCO
	AND	AL,0F0H		; Force all drive-selects off.
	OR	AL,81H		; Turn on auto-wait bit & select drive 0.
	ENDIF

	MOV	BYTE PTR [B2POKE_DRIVESELECT+1],AL
	MOV	AX,[SI+15]	; Poke sector size into boot sector.
	MOV	WORD PTR [B2POKE_SECSIZE+2],AX
	MOV	BX,OFFSET BOOT2SIDED
	JMP	SHORT WRITE_BOOT
	ENDIF

POKE_SINGLE:
	MOV	AX,[SI+13]	; Poke number of sectors to load into boot.
	MOV	WORD PTR [B1POKE_SECTOR+1],AX
	MOV	AL,[SI+11]	; Poke STARTSECTOR into boot sector.
	INC	AL		; First sector on a track is 1, not 0.
	MOV	BYTE PTR [B1POKE_FIRSECT+1],AL
	MOV	AL,[SI]		; Poke sectors/track two places into boot.
	MOV	BYTE PTR [B1POKE_MAXSECT_1+2],AL
	MOV	BYTE PTR [B1POKE_MAXSECT_2+2],AL

	IF	CROMEMCO
	CALL	DRIVESELECT	; Get drive-select byte.
	AND	AL,0F0H		; Force all drive-selects off.
	OR	AL,81H		; Turn on auto-wait bit & select drive 0.
	MOV	BYTE PTR [B1POKE_DRIVESELECT+1],AL
	ENDIF

	MOV	AX,[SI+15]	; Poke sector size into boot sector.
	MOV	WORD PTR [B1POKE_SECSIZE+2],AX
	MOV	BX,OFFSET BOOT1SIDED
WRITE_BOOT:
	MOV	AL,[DRIVE]	; Which drive to write the boot to.
	MOV	CX,1		; One sector.
	MOV	DX,0		; Write sector number 0.
	INT	38		; Call I/O system to write boot sector.
	POP	DX		; Pop the original flags off the stack.
	MOV	DX,OFFSET BOOT_ERROR	; Error message in case it didn't work.
	JC	ERROR
	RET
ERROR:
	MOV	AH,9		; Function 9, print string.
	INT	33
	STC
	RET

BADSECTOR:
	SUB	AX,AX		; No bad sectors, no errors.
	RET

DONE:
	CLC			; No errors.
	RET

	IF	CROMEMCO16FDC
;
; Subroutine to wait for spindle motor to come up to speed if it's off.
;
MOTORON:
	IN	AL,DISK+4	; Get "disk flags".
	TEST	AL,08H		; See if motor on.
	LAHF			; Save Z flag for below.
	CALL	DRIVESELECT	; Get drive-select byte.
	OUT	DISK+4,AL	; Send it out turning motors on.
	SAHF			; Get Z flag back from above.
	JNZ	MOTOR_RETURN	; If motors already on, don't wait.
	MOV	CX,43716	; Loop count, 1 second for loop below.
MOTORDELAY:			;  (8 MHz, 16-bit memory).
	AAM			; 83 clocks.
	AAM			; 83 clocks.
	LOOP	MOTORDELAY	; 17 clocks.
MOTOR_RETURN:
	RET
	ENDIF

;
; Set SI to point to a table of data for the selected disk format.
;
; [SI+0] = number of sectors/track
; [SI+1] = number of tracks (or cylindars) on disk.
; [SI+2] = number of bytes from beginning of format pattern track number is.
; [SI+4] = number of bytes in pattern for each sector.
; [SI+6] = address of pattern for index address mark.
; [SI+8] = address of pattern for each sector.
; [SI+10] = FATID byte for this format.
; [SI+11] = STARTSECTOR for this format.
; [SI+13] = number of sectors boot sector should load.
; [SI+15] = number of bytes/sector.
;
TABLE:
	IF	SCP+CROMEMCO
	SUB	AH,AH		; Zero out bit pattern for indexing.
	CALL	DRIVESELECT	; Get drive-select byte.

	IF	SCP
	NOT	AL		; Make LARGE-bit instead of SMALL-bit.
	ENDIF

	AND	AL,SMALLBIT	; See if small disk.
	JZ	SIZEOK		; Jump if small.
	ENDIF

	MOV	AH,02H		; Turn on bit 1 if 8-inch disk.
SIZEOK:

	IF	SCP+TARBELLDOUBLE+CROMEMCO16FDC
	TEST	BYTE PTR [SWITCHMAP],D_BIT
	JZ	DENSITYOK	; Jump if single-density.
	OR	AH,01H		; Turn on bit 0 if single-density.
DENSITYOK:
	ENDIF

	MOV	AL,AH		; Computed number to AL.
	MOV	AH,17		; And multiply by number of bytes in table.
	MUL	AH		; AX = AL*AH.
	ADD	AX,OFFSET DATATABLE	; Add the address of the table.
	MOV	SI,AX
	RET

DRIVESELECT:
	MOV	AL,[DRIVE]	; Get drive-select byte for drive [DRIVE].
	MOV	BX,OFFSET DRVTAB
	XLAT

	IF	SCP+CROMEMCO16FDC+TARBELLDOUBLE
	TEST	BYTE PTR [SWITCHMAP],D_BIT	; See if double-density.
	JZ	SPUTNIK		; Jump if not.
	OR	AL,DDENBIT	; Turn on double-density.
SPUTNIK:
	ENDIF

	RET

PUTSEC:
	PUSH	DX
	MOV	CH,[SI]		; CH = number of sectors.
	MOV	DX,[SI+4]	; DX = number of bytes in sector pattern.
SEC:
	MOV	[BX],AL		; Poke number in sector ID.
	ADD	BX,DX
	ADD	AL,CL		; Increment sector, side, or track number.
	DEC	CH
	JNZ	SEC
	POP	DX
	RET

MAKE:
	PUSH	SI
	MOV	SI,DX
MAKELOOP:
	CLD			; a.k.a. "UP"
	LODSB			; Get byte count.
	OR	AL,AL		; Return if zero.
	JZ	MAKERETURN
	MOV	CH,AL		; Count to CH.
	LODSB			; Get byte for pattern.
PUTPAT:
	MOV	[BX],AL		; Put byte in pattern.
	INC	BX
	DEC	CH
	JNZ	PUTPAT
	JMP	SHORT MAKELOOP
MAKERETURN:
	POP	SI
	RET
;
; Subroutine to restore head to track 0.
; On return, Z flag set if errors.
;
RESTORE:
	IF	SCP*FASTSEEK
	CALL	DRIVESELECT
	TEST	AL,SMALLBIT	; See if small disk.
	JNZ	NORMALRESTORE	; Normal (step) restore for small disks.
	OR	AL,80H		; Turn on RESTORE bit for PerSci drive.
	OUT	DISK+4,AL
SCWAIT:
	IN	AL,DISK+4	; Loop here till Seek Complete goes active.
	TEST	AL,40H
	JZ	SCWAIT
	CALL	DRIVESELECT	; Turn RESTORE off.
	OUT	DISK+4,AL
	SUB	AL,AL		; Tell 1793 which track the head is on.
	OUT	DISK+1,AL
	JMP	SHORT RESTORE_RETURN	; Z flag set SUB AL,AL above (no error)
NORMALRESTORE:
	ENDIF

	MOV	AL,08H+STPSPD	; Restore without verify
	CALL	DCOM
	TEST	AL,098H		; Check for errors, Not Ready,
RESTORE_RETURN:			;  Seek Error, CRC Error.
	RET

TRACK:

	IF	CROMEMCO
	CALL	DRIVESELECT	; Get drive-select byte.
	OR	AL,80H		; Turn on auto-wait.
	OUT	DISK+4,AL
	ENDIF

	MOV	DI,SI		; Save SI (pointer to DATATABLE).
	MOV	SI,OFFSET PATTERN
	MOV	BP,DX		; Save DX.
	MOV	DX,DISK+3	; Disk controller data port.
	MOV	AL,0F4H		; Write Track command.
	CLI			; Interrupts off.
	OUT	DISK,AL
WRTLP:
	IF	SCP
	IN	AL,DISK+5 		; Wait for DRQ or INTRQ.
	ENDIF

	IF	TARBELL+CROMEMCO
	IN	AL,DISK+4
	ENDIF

	IF	TARBELL
	SHL	AL,1
	LODSB			; Get a byte of the pattern.
	OUT	DX,AL		; Send to controller.
	JC	WRTLP
	ENDIF

	IF	SCP+CROMEMCO
	SHR	AL,1
	LODSB			; Get a byte of the pattern.
	OUT	DX,AL		; Send to controller.
	JNC	WRTLP
	ENDIF

	STI			; Interrupts back on.
	MOV	DX,BP		; Restore DX.
	MOV	SI,DI		; Restore SI.
	CALL	WAIT		; Wait till status ready.
	AND	AL,0E4H		; Accept "not ready", "write protect", "write
	JZ	WRITERET	;  fault", & "lost data" errors.
	STC			; Set CY flag if error.
WRITERET:
	RET

DCOM:
	OUT	DISK,AL
	AAM			; 10 Microsecond delay.
WAIT:
	IN	AL,DISK+4
	TEST	AL,DONEBIT

	IF	SCP+CROMEMCO
	JZ	WAIT
	ENDIF

	IF	TARBELL
	JNZ	WAIT
	ENDIF

	IN	AL,DISK		; Get status from disk.
	RET

DATATABLE:
	DB	18		; Number of sectors/track 5.25-inch SD/SS.
	DB	40		; Number of tracks/disk 5.25-inch SD/SS format.
	DW	11		; Beginning of pattern to first ID mark.
	DW	168		; Number of bytes/sector in pattern.
	DW	OFFSET SSINDEX	; Address of index pattern 5.25-inch SD/SS.
	DW	OFFSET SSSECTOR	; Address of sector pattern 5.25-inch SD/SS.
	DB	0FEH		; FATID byte for 5.25-inch SD/SS format.
	DW	54+4+4+16	; STARTSECTOR for 5.25-inch SD/SS format.
	DW	80		; Number of sectors boot sector should load.
	DW	128		; Bytes/sector.

	IF	SMALLDS-1
	DB	8		; 5.25-inch DD/SS format.
	DB	40
	DW	162
	DW	652
	DW	OFFSET SDINDEX
	DW	OFFSET SDSECTOR
	DB	0FEH
	DW	1+1+1+4
	DW	20
	DW	512
	ENDIF

	IF	SMALLDS
	DB	8		; 5.25-inch DD/DS format.
	DB	40
	DW	162
	DW	652
	DW	OFFSET SDINDEX
	DW	OFFSET SDSECTOR
	DB	0FFH
	DW	1+1+1+7
	DW	20
	DW	512
	ENDIF

	DB	26		; 8-inch SD/SS format.
	DB	77
	DW	80
	DW	186
	DW	OFFSET LSINDEX
	DW	OFFSET LSSECTOR
	DB	0FEH
	DW	1+6+6+17
	DW	80
	DW	128

	IF	LARGEDS-1
	DB	8		; 8-inch DD/SS format.
	DB	77
	DW	162
	DW	1138
	DW	OFFSET LDINDEX
	DW	OFFSET LDSECTOR
	DB	0FEH
	DW	1+1+1+3
	DW	10
	DW	1024
	ENDIF

	IF	LARGEDS
	DB	8		; 8-inch DD/DS format.
	DB	77
	DW	162
	DW	1138
	DW	OFFSET LDINDEX
	DW	OFFSET LDSECTOR
	DB	0FEH
	DW	1+2+2+6
	DW	10
	DW	1024
	ENDIF

LDINDEX:			; Pattern for 8-inch double-density.
	DB	80,4EH
	DB	12,0
	DB	3,0F6H
	DB	1,0FCH
	DB	50,4EH
LDSECTOR:
	DB	12,0
	DB	3,0F5H
	DB	1,0FEH
	DB	3,0		; Track, side, and sector
	DB	1,3		; Sector size=1024
	DB	1,0F7H
	DB	22,4EH
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH
	DB	255,0E5H
	DB	255,0E5H
	DB	255,0E5H
	DB	255,0E5H
	DB	4,0E5H
	DB	1,0F7H
	DB	54,4EH
	DB	0

	DB	255,4EH
	DB	255,4EH
	DB	255,4EH
	DB	0

LSINDEX:			; Pattern for 8-inch single-density.
	DB	40,-1
	DB	6,0
	DB	1,0FCH
	DB	26,-1
LSSECTOR:
	DB	6,0
	DB	1,0FEH
	DB	4,0
	DB	1,0F7H
	DB	11,-1
	DB	6,0
	DB	1,0FBH
	DB	128,0E5H
	DB	1,0F7H
	DB	27,-1
	DB	0

	DB	255,-1
	DB	255,-1
	DB	0

SDINDEX:			; Pattern for 5.25-inch double-density.
	DB	80,4EH
	DB	12,0
	DB	3,0F6H
	DB	1,0FCH
	DB	50,4EH
SDSECTOR:
	DB	12,0
	DB	3,0F5H
	DB	1,0FEH
	DB	3,0		; Track, side, and sector.
	DB	1,2		; Sector size = 512.
	DB	1,0F7H
	DB	22,4EH
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH
	DB	255,0E5H
	DB	255,0E5H
	DB	2,0E5H
	DB	1,0F7H
	DB	80,4EH
	DB	0

	DB	255,4EH
	DB	255,4EH
	DB	255,4EH
	DB	255,4EH
	DB	255,4EH
	DB	255,4EH
	DB	0

SSINDEX:			; Pattern for 5.25-inch single-density.
	DB	4,-1		; No index mark.
SSSECTOR:
	DB	6,0
	DB	1,0FEH
	DB	4,0
	DB	1,0F7H
	DB	11,-1
	DB	6,0
	DB	1,0FBH
	DB	128,0E5H
	DB	1,0F7H
	DB	9,-1
	DB	0

	DB	255,0
	DB	255,0
	DB	0

	IF	TARBELLDOUBLE
DRVTAB	DB	00H,10H,20H,30H
	ENDIF

	IF	TARBELLSINGLE
DRVTAB:	DB	0F2H,0E2H,0D2H,0C2H
	ENDIF

	IF	CROMEMCO*LARGE
DRVTAB:	DB	31H,32H,34H,38H
	ENDIF

	IF	CROMEMCO*SMALL
DRVTAB:	DB	21H,22H,24H,28H
	ENDIF

	IF	CROMEMCO*COMBIN
DRVTAB:	DB	31H,32H,24H
	ENDIF

	IF	SCP*LARGE
DRVTAB:	DB	00H,01H,02H,03H
	ENDIF

	IF	SCP*SMALL
DRVTAB:	DB	10H,11H,12H,13H
	ENDIF

	IF	SCP*COMBIN
DRVTAB:	DB	00H,01H,10H
	ENDIF
;
; Error messages.
;
	IF	SCP+TARBELLDOUBLE+CROMEMCO16FDC
READ_ERROR	DB	"Read Error - can't determine density",13,10,'$'
	ENDIF

SEEK_ERROR	DB	'Seek Error - disk not ready',13,10,'$'
WRITE_ERROR	DB	'Write Error - not ready, write protect, '
		DB	'write fault, or lost data',13,10,'$'
BOOT_ERROR	DB	'Error writing boot sector',13,10,'$'

SWITCHLIST	DB	4,'BCDS'
FATID		DB	0
STARTSECTOR	DW	0
FREESPACE	DW	OFFSET PATTERN+12000
;
; Boot sectors, one for single-sided boot, a second for double-sided boot.
; Both have various variables such as STARTSECTOR and number of sectors to
; load poked in before the boot sector is written to the disk.  The boot
; sectors should be ORGed at 200 hex, but since all jumps and calls are
; reletive, it doesn't matter that it is ORGed at a random location.
;
BOOT1SIDED:
	CLI			; Interrupts off.
	XOR	AX,AX
	MOV	DS,AX
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,BOOTER	; For debugging purposes.
	CLD			; a.k.a. "UP"
	MOV	DI,BIOSSEG*16
B1POKE_SECTOR:
	MOV	CX,0		; CX = number of sectors/track.
B1POKE_FIRSECT:
	MOV	BL,0		; BL = first sector to load.
B1SECT:
	MOV	AL,0D0H		; Force Interrupt command.
	OUT	DISK,AL		; To force Type I status
	AAM			; Give force interrupt time.
	AAM
	AAM
	AAM
B1SEEKLP:
B1POKE_MAXSECT_1:
	CMP	BL,0		; Compare with number of sectors/track.
	JBE	B1NOSTEP
	MOV	AL,58H		; Step in with update.
	CALL	B1DCOM
B1POKE_MAXSECT_2:
	SUB	BL,0		; Subtract number of sectors/track.
	JMP	SHORT B1SEEKLP
B1NOSTEP:
	MOV	AL,BL		; Get sector number.
	OUT	DISK+2,AL	; Output sector number to disk controller.

	IF	CROMEMCO
B1POKE_DRIVESELECT:
	MOV	AL,0		; AL = drive-select byte to turn on auto-wait.
	OUT	DISK+4,AL	; Turn on hardware wait
	ENDIF

	MOV	DX,DISK+3	; Disk controller data port.
	PUSH	DI

	IF	CROMEMCO4FDC+TARBELLSINGLE
	IN	AL,DISK		; Get head load status.
	NOT	AL
	AND	AL,20H
	JZ	B1OUTCOM
	MOV	AL,4
B1OUTCOM:
	OR	AL,88H		; Read Sector command.
	ENDIF

	IF	SCP+CROMEMCO16FDC+TARBELLDOUBLE
	MOV	AL,88H		; Read Sector command.
	ENDIF

	OUT	DISK,AL
	JMP	SHORT B1READ
B1READLOOP:
	STOSB			; Put in memory.
B1READ:

	IF	SCP
	IN	AL,DISK+5	; Input from auto-wait port.
	ENDIF

	IF	TARBELL+CROMEMCO
	IN	AL,DISK+4
	ENDIF

	IF	TARBELL
	ROL	AL,1
	IN	AL,DX		; Read data from disk controller chip.
	JC	B1READLOOP
	ENDIF

	IF	SCP+CROMEMCO
	ROR	AL,1
	IN	AL,DX		; Read data from disk controller chip.
	JNC	B1READLOOP
	ENDIF

	POP	DI
	CALL	B1STAT
	AND	AL,9CH
	JNZ	B1SECT
B1POKE_SECSIZE:
	ADD	DI,128		; Add sector size to load next sector.
	INC	BL
	LOOP	B1SECT
	JMP	BIOS

B1DCOM:
	OUT	DISK,AL
	AAM
B1STAT:
	IN	AL,DISK+4
	TEST	AL,DONEBIT

	IF	TARBELL
	JNZ	B1STAT
	ENDIF

	IF	SCP+CROMEMCO
	JZ	B1STAT
	ENDIF

	IN	AL,DISK
	RET

	IF	(SCP+CROMEMCO16FDC)*(LARGEDS+SMALLDS)+TARBELLDOUBLE*LARGEDS
BOOT2SIDED:
	CLI			; Interrupts off.
	XOR	AX,AX
	MOV	DS,AX
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,BOOTER	; For debugging purposes.
	CLD			; a.k.a. "UP"
	MOV	DI,BIOSSEG*16
B2POKE_SECTOR:
	MOV	CX,0		; CX = number of sectors/track.
B2POKE_FIRSECT:
	MOV	BL,0		; BL = first sector to load.
B2SECT:
	MOV	AL,0D0H		; Force Interrupt command.
	OUT	DISK,AL		; To force Type I status
	AAM			; Give force interrupt time.
	AAM
	AAM
	AAM
B2SEEKLP:
B2POKE_MAXSECT_1:
	CMP	BL,0		; Compare with number of sectors/track.
	JBE	B2NOSTEP
	MOV	AL,58H		; Step in with update.
	CALL	B2DCOM
B2POKE_MAXSECT_2:
	SUB	BL,0		; Subtract number of sectors/track.
	JMP	SHORT B2SEEKLP
B2NOSTEP:
	MOV	AL,BL		; Get sector number.

	IF	SCP+TARBELL
	MOV	AH,0		; Assume side 0.
	ENDIF

	IF	CROMEMCO
	MOV	AH,0FFH		; Assume side 0.
	ENDIF

B2POKE_HALFSECT_1:
	CMP	AL,0		; Find out which sector and side to use.
	JBE	B2SIDE
B2POKE_HALFSECT_2:
	SUB	AL,0		; Compute sector number for back side.

	IF	SCP
	MOV	AH,04H		; Side 1 bit.
	ENDIF

	IF	TARBELL
	MOV	AH,40H		; Side 1 bit.
	ENDIF

	IF	CROMEMCO
	MOV	AH,0FDH		; Side 1 bit.
	ENDIF

B2SIDE:
	OUT	DISK+2,AL	; Output sector number to disk controller.

	IF	SCP+TARBELL
	MOV	AL,AH		; Get side-select byte.
B2POKE_DRIVESELECT:
	OR	AL,0		; Add the rest of the drive-select bits.
	OUT	DISK+4,AL	; And send the mess out.
	ENDIF

	IF	CROMEMCO
B2POKE_DRIVESELECT:
	MOV	AL,0
	OUT	DISK+4,AL	; Turn on hardware wait
	MOV	AL,AH		; Get side select byte.
	OUT	04H,AL		; Send to Auxillary drive-select port.
	ENDIF

	MOV	DX,DISK+3	; Disk controller data port.
	PUSH	DI

	IF	CROMEMCO4FDC+TARBELLSINGLE
	IN	AL,DISK		; Get head load status.
	NOT	AL
	AND	AL,20H
	JZ	B2OUTCOM
	MOV	AL,4
B2OUTCOM:
	OR	AL,88H		; Read Sector command.
	ENDIF

	IF	SCP+CROMEMCO16FDC+TARBELLDOUBLE
	MOV	AL,88H		; Read Sector command.
	ENDIF

	OUT	DISK,AL
	JMP	SHORT B2READ
B2READLOOP:
	STOSB			; Put in memory.
B2READ:

	IF	SCP
	IN	AL,DISK+5	; Input from auto-wait port.
	ENDIF

	IF	TARBELL+CROMEMCO
	IN	AL,DISK+4
	ENDIF

	IF	TARBELL
	ROL	AL,1
	IN	AL,DX		; Read data from disk controller chip.
	JC	B2READLOOP
	ENDIF

	IF	SCP+CROMEMCO
	ROR	AL,1
	IN	AL,DX		; Read data from disk controller chip.
	JNC	B2READLOOP
	ENDIF

	POP	DI
	CALL	B2STAT
	AND	AL,9CH
	JNZ	B2SECT
B2POKE_SECSIZE:
	ADD	DI,128		; Add sector size to load next sector.
	INC	BL
	LOOP	B2SECT
	JMP	BIOS

B2DCOM:
	OUT	DISK,AL
	AAM
B2STAT:
	IN	AL,DISK+4
	TEST	AL,DONEBIT

	IF	TARBELL
	JNZ	B2STAT
	ENDIF

	IF	SCP+CROMEMCO
	JZ	B2STAT
	ENDIF

	IN	AL,DISK
	RET
	ENDIF			; End of double-sided boot sector.

PATTERN	LABEL	BYTE		; 12000-byte buffer for track pattern.

CODE	ENDS
	END
